<?php
// Set the API endpoint and your API token
$api_url = "https://pay.imb.org.in/api/check-order-status";
$user_token = "2048f66bef68633fa3262d7a398ab577"; // Replace with your actual API token
$order_id = "9876543210"; // Replace with the actual order ID

// Prepare the data to be sent via POST
$post_data = [
    'user_token' => $user_token,
    'order_id' => $order_id
];

// Initialize cURL session
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// Execute cURL request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo 'Error: ' . curl_error($ch);
} else {
    // Decode the JSON response
    $response_data = json_decode($response, true);

    // Check the response status
    if ($response_data['status'] == "COMPLETED") {
        echo "Transaction Status: " . $response_data['result']['txnStatus'] . "\n";
        echo "Message: " . $response_data['message'] . "\n";
        echo "Order ID: " . $response_data['result']['orderId'] . "\n";
        echo "Amount: " . $response_data['result']['amount'] . "\n";
        echo "Date: " . $response_data['result']['date'] . "\n";
        echo "UTR: " . $response_data['result']['utr'] . "\n";
    } else {
        echo "Error: " . $response_data['message'];
    }
}

// Close the cURL session
curl_close($ch);
?>