import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.Body
import retrofit2.http.POST

class CreateOrderActivity : AppCompatActivity() {

    private val apiService by lazy { createApiService() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createOrder()
    }

    private fun createOrder() {
        val orderId = (123456789..999999999).random() // Generate a unique order ID
        val token = "542a08bc000ceb2570dca59993610565" // Replace with your API token
        
        val orderRequest = OrderRequest(
            customer_mobile = "1234567890",
            user_token = token,
            amount = "2",
            order_id = orderId.toString(),
            redirect_url = "https://your_Redirect_URL.in/",
            remark1 = "Customer-email@gmail.com",
            remark2 = "Additional data here"
        )

        apiService.createOrder(orderRequest).enqueue(object : retrofit2.Callback<OrderResponse> {
            override fun onResponse(call: retrofit2.Call<OrderResponse>, response: retrofit2.Response<OrderResponse>) {
                if (response.isSuccessful) {
                    val paymentUrl = response.body()?.result?.payment_url
                    Log.d("CreateOrder", "Redirect to Payment URL: $paymentUrl")
                } else {
                    Log.e("CreateOrder", "Error: ${response.message()}")
                }
            }

            override fun onFailure(call: retrofit2.Call<OrderResponse>, t: Throwable) {
                Log.e("CreateOrder", "Failed to execute request: ${t.message}")
            }
        })
    }

    private fun createApiService(): ApiService {
        val client = OkHttpClient.Builder().build()
        val retrofit = Retrofit.Builder()
            .baseUrl("https://pay.imb.org.in/api/")
            .client(client)
            .addConverterFactory(GsonConverterFactory.create())
            .build()

        return retrofit.create(ApiService::class.java)
    }
}

data class OrderRequest(
    val customer_mobile: String,
    val user_token: String,
    val amount: String,
    val order_id: String,
    val redirect_url: String,
    val remark1: String,
    val remark2: String
)

data class OrderResponse(
    val result: Result
)

data class Result(
    val payment_url: String
)
