from flask import Flask, request

app = Flask(__name__)

@app.route('/webhook', methods=['POST'])
def webhook():
    data = request.form
    status = data.get('status')
    order_id = data.get('order_id')
    remark1 = data.get('remark1')
    
    # Log webhook data to file for debugging
    with open('webhook_log.txt', 'a') as log_file:
        log_file.write(str(data) + "\n")

    # Update transaction status in the database
    if status == "SUCCESS":
        update_transaction_status(order_id, 'SUCCESS', remark1)
        return f"Transaction successful for Order ID: {order_id}"
    elif status == "FAILD":
        update_transaction_status(order_id, 'FAILED', remark1)
        return f"Transaction failed for Order ID: {order_id}"
    else:
        return "Invalid status received", 400

def update_transaction_status(order_id, status, remark):
    # Implement database update logic here
    print(f"Updating transaction {order_id} to {status} with remark: {remark}")

if __name__ == "__main__":
    app.run(port=5000)
