require 'net/http'
require 'uri'
require 'json'

# Set up the URL and your API token
url = URI.parse('https://pay.imb.org.in/api/create-order')
order_id = rand(123456789..999999999) # Generate a unique order ID
token = '542a08bc000ceb2570dca59993610565' # Replace with your API token

data = {
  customer_mobile: '1234567890',
  user_token: token,
  amount: '2',
  order_id: order_id,
  redirect_url: 'https://your_Redirect_URL.in/',
  remark1: 'Customer-email@gmail.com',
  remark2: 'Additional data here'
}

# Set up the HTTP request
http = Net::HTTP.new(url.host, url.port)
http.use_ssl = true
request = Net::HTTP::Post.new(url.request_uri)
request.set_form_data(data)

# Execute the request
response = http.request(request)

# Parse and handle the response
if response.is_a?(Net::HTTPSuccess)
  json_response = JSON.parse(response.body)
  payment_url = json_response.dig("result", "payment_url")
  
  if payment_url
    puts "Redirect to Payment URL: #{payment_url}"
  else
    puts "Error: #{json_response['message']}"
  end
else
  puts "Request failed: #{response.message}"
end
