require 'net/http'
require 'uri'
require 'json'

api_url = URI.parse('https://pay.imb.org.in/api/check-order-status')
user_token = '2048f66bef68633fa3262d7a398ab577'  # Replace with your API token
order_id = '9876543210'  # Replace with the actual order ID

# Set up the POST data
data = {
  user_token: user_token,
  order_id: order_id
}

# Set up the HTTP request
http = Net::HTTP.new(api_url.host, api_url.port)
http.use_ssl = true
request = Net::HTTP::Post.new(api_url.request_uri)
request.set_form_data(data)

# Execute the request and handle response
response = http.request(request)

if response.is_a?(Net::HTTPSuccess)
  response_data = JSON.parse(response.body)
  
  if response_data['status'] == 'COMPLETED'
    result = response_data['result']
    puts "Transaction Status: #{result['txnStatus']}"
    puts "Message: #{response_data['message']}"
    puts "Order ID: #{result['orderId']}"
    puts "Amount: #{result['amount']}"
    puts "Date: #{result['date']}"
    puts "UTR: #{result['utr']}"
  else
    puts "Error: #{response_data['message']}"
  end
else
  puts "Request failed: #{response.message}"
end
