<?php

function Imb_payment_config()
{
    // Get the current domain dynamically
    $domain = 'https://' . $_SERVER['HTTP_HOST'];
    
    // Define the fixed part of the URL
    $webhookPath = '/modules/gateways/callback/Imb_payment.php';
    
    // Create the complete webhook URL
    $webhookURL = $domain . $webhookPath;
    
    return array(
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Imb Payment',
        ),
        'apiKey' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter your API key here',
        ),
        'webhookURL' => array(
            'FriendlyName' => 'Webhook URL',
            'Type' => 'custom',
            'Description' => '
                <div style="display: flex; align-items: center;">
                    <input type="text" id="webhookURL" value="' . $webhookURL . '" readonly style="width: 70%; padding: 5px; border: 1px solid #ccc; border-radius: 5px;">
                    <button type="button" onclick="copyWebhookURL()" style="margin-left: 10px; background: none; border: none; cursor: pointer;">
                        <img src="https://img.icons8.com/ios-glyphs/30/000000/copy.png" alt="Copy" title="Copy Webhook URL">
                    </button>
                </div>
                <script>
                    function copyWebhookURL() {
                        var copyText = document.getElementById("webhookURL");
                        copyText.select();
                        copyText.setSelectionRange(0, 99999); /* For mobile devices */
                        document.execCommand("copy");
                        
                        // Create a temporary tooltip for feedback
                        var tooltip = document.createElement("div");
                        tooltip.innerText = "Copied!";
                        tooltip.style.position = "absolute";
                        tooltip.style.background = "#4CAF50";
                        tooltip.style.color = "white";
                        tooltip.style.padding = "5px";
                        tooltip.style.borderRadius = "3px";
                        tooltip.style.top = "0";
                        tooltip.style.right = "0";
                        document.body.appendChild(tooltip);
                        
                        // Remove tooltip after 1.5 seconds
                        setTimeout(function() {
                            document.body.removeChild(tooltip);
                        }, 1500);
                    }
                </script>',
        ),
    );
}

function Imb_payment_link($params)
{
    $key = $params['apiKey'];
    $userToken = $key; // Using apiKey as the user token

    // Invoice Parameters
    $invoiceId = $params['invoiceid'];
    $description = $params['description'];
    $amount = $params['amount'];
    $currencyCode = $params['currency'];

    // Client Parameters
    $phone = $params['clientdetails']['phonenumber'];

    // System Parameters
    $systemUrl = $params['systemurl'];
    $moduleName = $params['paymentmethod'];

    // Callback URL (Webhook URL for payment confirmation)
    $webhookurl = $systemUrl . '/modules/gateways/callback/' . $moduleName . '.php';  //this is webhook URL;
    
    // Redirect URL after successful payment (invoice page)
    $redirectURL = $systemUrl . 'clientarea.php?action=invoices';

    // Create the payment link
    $orderID = uniqid() . time() . rand(1111111111, 9999999999);

    // URL of the PHP page to initiate the payment
    $url = 'https://pay.imb.org.in/api/create-order';

    // Data to be sent in the POST request
    $data = array(
        'customer_mobile' => '9876543210',
        'user_token' => $key,
        'amount' => $amount,
        'order_id' => $orderID,
        'redirect_url' => $redirectURL,  // Redirect URL to WHMCS invoice page
        'remark1' => $invoiceId,
        'remark2' => $invoiceId,
    );

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Execute cURL session and store the response
    $response = curl_exec($ch);

    // Close cURL session
    curl_close($ch);

    // Decode the JSON response
    $jsonResponse = json_decode($response, true);

    // Check if decoding was successful
    if ($jsonResponse !== null) {
        // Check if the response contains the expected keys
        if (isset($jsonResponse['result']['payment_url'])) {
            // Redirect the user to the payment URL
            // Store values in cookies
            setcookie('invoiceId', $invoiceId, time() + 3600); // Expires in 1 hour
            setcookie('gatewayTxnID', $orderID, time() + 3600); // Expires in 1 hour
            
            $paymentUrl = $jsonResponse['result']['payment_url'];
            
            // Redirect the user to the payment gateway
            header('Location: ' . $paymentUrl);
            exit;
        } else {
            echo 'Payment URL not found in the response.';
            // Handle the error appropriately, for example:
            // die('Payment URL not found in the response.');
        }
    } else {
        echo 'Failed to decode JSON response.';
        // Handle the error appropriately, for example:
        // die('Failed to decode JSON response.');
    }
}

// Webhook Handling for Payment Confirmation (callback handler)
function Imb_payment_callback($params)
{
    // Callback Parameters
    $invoiceId = $_GET['remark1'];
    $orderID = $_GET['remark2'];
    $status = $_GET['status']; // Status returned by payment gateway
    $amountPaid = $_GET['amount'];
    
    // Validate and handle the payment confirmation
    if ($status === 'SUCCESS') {
        // Mark the invoice as paid in WHMCS
        $invoice = localAPI('acceptpayment', array(
            'invoiceid' => $invoiceId,
            'amount' => $amountPaid,
            'transid' => $orderID,
            'method' => 'Imb Payment',
        ));

        if ($invoice['result'] === 'success') {
            // Redirect the user to the invoice page (Optional: Can be used to confirm successful payment)
            header('Location: ' . $params['systemurl'] . 'clientarea.php?action=invoices');
            exit;
        } else {
            echo 'Payment Acceptance Failed. Please contact support.';
            // Optionally log the error or take further action
        }
    } else {
        echo 'Payment Failed. Please try again or contact support.';
        // Optionally log the error or take further action
    }
}

function Imb_payment_cancelSubscription($params)
{
    // Subscription Parameters
    $subscriptionIdToCancel = $params['subscriptionID'];

    // System Parameters
    $companyName = $params['companyname'];
    $systemUrl = $params['systemurl'];
    $langPayNow = $params['langpaynow'];
    $moduleDisplayName = $params['name'];
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    // Perform API call to cancel the subscription and interpret the result
    // Add your code here to cancel the subscription using the $subscriptionIdToCancel

    // Return the response
    return array(
       'status' => 'success', // 'success' if successful, any other value for failure
        'rawdata' => $responseData, // Data to be recorded in the gateway log - can be a string or array
    );
}
?>