<?php
// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

$gatewayModuleName = basename(__FILE__, '.php');

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

// Get POST data
$invoiceId = $_POST['result']['remark1'];
$gatewayTxnID = $_COOKIE['gatewayTxnID'];
$status = $_POST['status'];
$orderid = $_POST['order_id'];
$amount = $_POST['result']['amount'];

if ($status == "SUCCESS") {
    // Ensure the transaction is not duplicated
    $existingTransaction = select_query(
        "tblaccounts",
        "id",
        [
            "transid" => $orderid,
            "invoiceid" => $invoiceId,
        ]
    );
    $transactionExists = mysql_num_rows($existingTransaction) > 0;

    if (!$transactionExists) {
        // Add payment to the invoice
        $transactionId = $orderid;
        $paymentAmount = $amount;
        $paymentFee = 0; // Assuming no payment fee
        addInvoicePayment(
            $invoiceId,
            $transactionId,
            $paymentAmount,
            $paymentFee,
            $gatewayModuleName
        );

        // Redirect the user to the success URL
        callback3DSecureRedirect($invoiceId, true);
    } else {
        echo "Duplicate transaction detected. Payment not added.<br>";
    }

    exit;
} else {
    echo "Invalid response received<br>";
}
?>
